using System;
namespace Takmicenje 
{
    public class Program
    {
        public static void Main(string[] args)
        {
            int n = int.Parse(Console.ReadLine());
            string[] current = Console.ReadLine().Split(' ');
            string[] capacity = Console.ReadLine().Split(' ');

            Container[] containers = new Container[n];
            for (int i = 0; i < n; i++) {
                containers[i] = new Container(int.Parse(current[i]), int.Parse(capacity[i]));
            }

            int q = int.Parse(Console.ReadLine());
            for (int i = 0; i < q; i++) {
                string[] s = Console.ReadLine().Split(' ');
                int index = int.Parse(s[0]);
                int reports = int.Parse(s[1]);
                AddReports(containers, index - 1, reports);
            }

            Console.WriteLine(string.Join(" ", (object[])containers));
        }

        static void AddReports(Container[] containers, int index, int reports) {
            if (index >= containers.Length) return;
            Container c = containers[index];
            int space = c.capacity - c.current;
            if (reports > space) {
                c.current = c.capacity;
                AddReports(containers, index + 1, reports - space);
            } else {
                c.current += reports;
            }
        }
    }
    
    class Container {
        public int current;
        public int capacity;

        public Container(int curr, int cap) {
            current = curr;
            capacity = cap;
        }
		
		public override string ToString()
        {
            return current.ToString();
        }
    }
}